<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2012 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

// #############################################################################
if ($_REQUEST['action'] == 'statistics' OR empty($_REQUEST['action']))
{
	if (!$vbulletin->options['dbtech_usertag_enablestats'])
	{
		// Stats page is off
		print_no_permission();
	}
	
	// Set the limit on number of users to fetch
	$limit = (isset($vbulletin->options['dbtech_usertag_statistics_topx']) ? $vbulletin->options['dbtech_usertag_statistics_topx'] : 5);
	
	// Start SQL
	$SQL = array();
	
	$types = array(
		1 => 'dbtech_usertag_mention',
		2 => 'dbtech_usertag_tag',
		4 => 'dbtech_usertag_quote'
	);
	foreach ($types as $key => $type)
	{
		if ($vbulletin->options['dbtech_usertag_disabledfeatures'] & $key)
		{
			// Skip this
			continue;
		}
		
		$SQL[] = "
		(
			SELECT
				{$type}s AS value,
				'" . substr($type, strlen('dbtech_usertag_')) . "' AS typeid,
				user.userid,
				user.username,
				user.usergroupid,
				user.membergroupids,
				infractiongroupid,
				displaygroupid
				" . ($vbulletin->products['dbtech_vbshop'] ? ", user.dbtech_vbshop_purchase" : '') . "
			FROM " . TABLE_PREFIX . "user AS user
			LEFT JOIN " . TABLE_PREFIX . "usergroup AS usergroup ON (usergroup.usergroupid = user.usergroupid)
			WHERE (usergroup.genericoptions & " . $vbulletin->bf_ugp_genericoptions['isnotbannedgroup'] . ")
			GROUP BY user.userid
			ORDER BY value DESC
			LIMIT $limit
		)
		";
		$SQL[] = "
		(
			SELECT
				COUNT(*) AS value,
				'" . substr($type, strlen('dbtech_usertag_')) . "2' AS typeid,
				user.userid,
				user.username,
				user.usergroupid,
				user.membergroupids,
				infractiongroupid,
				displaygroupid
				" . ($vbulletin->products['dbtech_vbshop'] ? ", user.dbtech_vbshop_purchase" : '') . "
			FROM " . TABLE_PREFIX . "$type AS " . substr($type, strlen('dbtech_usertag_')) . "
			LEFT JOIN " . TABLE_PREFIX . "user AS user USING(userid)
			LEFT JOIN " . TABLE_PREFIX . "usergroup AS usergroup ON (usergroup.usergroupid = user.usergroupid)
			WHERE (usergroup.genericoptions & " . $vbulletin->bf_ugp_genericoptions['isnotbannedgroup'] . ")
			GROUP BY user.userid
			ORDER BY value DESC
			LIMIT $limit
		)
		";
	}
		
	// Init this array
	$leaders = array();
	
	if (!count($SQL))
	{
		// This went wrong
		return false;
	}
	
	if (class_exists('vb_optimise'))
	{
		vb_optimise::cache('usertagstats', $SQL, $leaders);
	}

	if (!count($leaders))
	{
		// Fetch rewards
		$leaders_q = $db->query_read_slave(implode(' UNION ALL ', $SQL));
				
		while ($leaders_r = $db->fetch_array($leaders_q))
		{
			// Grab the musername
			fetch_musername($leaders_r);
			
			// Store a cache of the leaders
			$leaders[$leaders_r['typeid']][] = $leaders_r;
		}
		$db->free_result($leaders_q);
		unset($leaders_r);
	}
	
	// Init these
	$i = 0;
	$leaderboardbits = '';
	
	foreach ($types as $key => $type)
	{
		if ($vbulletin->options['dbtech_usertag_disabledfeatures'] & $key)
		{
			// Skip this
			continue;
		}

		$type = substr($type, strlen('dbtech_usertag_'));
		
		foreach (array('', '2') as $suffix)
		{
			$type .= $suffix;
			
			// Init this
			$userbits = array();
			$xmlbits = array();
			
			foreach ((array)$leaders["$type"] as $key => $userinfo)
			{
				if ($userinfo['value'] == 0)
				{
					// We don't want to count empty users
					continue;
				}
				
				$userinfo['musername'] = '<a href="member.php?' . $vbulletin->session->vars['sessionurl'] . 'u=' . $userinfo['userid'] . '&amp;tab=' . ($type == 'tags' ? 'usertags' : $type) . '" target="_blank">' . $userinfo['musername'] . '</a>';
				
				$j = ++$key;
				$templater = vB_Template::create('dbtech_usertag_statistics_userbit');
					$templater->register('userinfo', $userinfo);
				$userbits["$j"] .= $templater->render();
	
				if ($_REQUEST['xml'])
				{
					$xmlbits[] = array($results_r['hash'], $link, $userinfo['value']);
				}
			}
			
			for ($k = 1; $k <= $limit; $k++)
			{
				if (!$userbits["$k"])
				{
					// Didn't have this point
					$userbits["$k"] = vB_Template::create('dbtech_usertag_statistics_userbit')->render();
				}
			}
			
			// Make sure we also got the phrase
			$phrase = $vbphrase["dbtech_usertag_top{$type}"];
			
			if ($_REQUEST['xml'])
			{
				$this->xml[] = array(
					'phrase'	=> $phrase,
					'bits'		=> $xmlbits,
				);
			}
			
			$templater = vB_Template::create('dbtech_usertag_statistics_statisticbit');
				$templater->register('phrase', $phrase);
				$templater->register('userbits', implode('', $userbits));
			$leaderboardbits .= $templater->render();
						
			$i++;
			/*
			if ($i % 6 == 0)
			{
				// Linebreak tiem
				$leaderboardbits .= '<br />';
			}
			*/
		}
	}
	
	// Set page titles
	$pagetitle = $navbits[] = $vbphrase['dbtech_usertag_statistics'];
	
	// Begin the page template
	$page_templater = vB_Template::create('dbtech_usertag_statistics');
		$page_templater->register('pagetitle', $pagetitle);
		$page_templater->register('leaderboardbits', $leaderboardbits);
	$HTML = $page_templater->render();
}